/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import "MarkupHelper.h"
#import "StringHelper.h"

#define IS_IPAD	(UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad)
#define BASE_TEXT_SIZE	(IS_IPAD ? 24.0f : 14.0f)
#define STRMATCH(STRING1, STRING2) ([[STRING1 uppercaseString] rangeOfString:[STRING2 uppercaseString]].location != NSNotFound)

@implementation MarkupHelper
+ (NSAttributedString *) stringFromMarkup: (NSString *) inputString
{
    NSString *aString = [inputString stringByReplacingOccurrencesOfString:@"\n" withString:@""];
    
	// Przygotowanie do skanowania.
	NSScanner *scanner = [NSScanner scannerWithString:aString];
	[scanner setCharactersToBeSkipped:[NSCharacterSet newlineCharacterSet]];
	NSCharacterSet *startSet = [NSCharacterSet characterSetWithCharactersInString:@"<"];
	NSCharacterSet *endSet = [NSCharacterSet characterSetWithCharactersInString:@">"];
	
	// Przygotowanie do skanowania.
	StringHelper *stringHelper = [StringHelper buildHelper];
	CGFloat fontSize = BASE_TEXT_SIZE;
    
	// Przygotowanie do skanowania.
	int hlevel = 0;
	BOOL bold = NO, emph = NO;
	
	NSUInteger loc = 0;
	while (loc < aString.length)
	{
		NSString *contentText = nil; // Skanowanie do znacznika.
		[scanner scanUpToCharactersFromSet:startSet intoString:&contentText];
		
		// Obsługa treści w postaci tekstu (nie znaczników).
		if (contentText)
		{
			// Przejście do przodu, do kolejnego położenia.
			scanner.scanLocation = (loc += contentText.length + 1);
            
			// OUstawienie czcionki dla treści.
			NSString *fontName = @"Futura-Medium";
			if (hlevel == 0)
			{
				//if (bold && emph) fontName = @"Futura-Medium";
				if (bold) fontName = @"Futura-CondensedExtraBold";
				else if (emph) fontName = @"Futura-MediumItalic";
			}
			
			stringHelper.fontName = fontName;
			stringHelper.fontSize = fontSize;
			[stringHelper appendFormat:contentText];
		}
        
		// Skanowanie w poszukiwaniu znacznika.
		NSString *baseTag = nil; 
		[scanner scanUpToCharactersFromSet:endSet intoString:&baseTag];
		if (!baseTag)
		{
			NSLog(@"Podczas skanowania wystąpił nieoczekiwany błąd.");
			return stringHelper.string;
		}
		
		// Przejście do przodu, do kolejnego położenia.
		scanner.scanLocation = (loc += baseTag.length + 1);
		
		// Przywrócenie standardowej postaci znacznika.
		NSString *tagText = [baseTag stringByAppendingString:@">"];
		if (![tagText hasPrefix:@"<"]) 
			tagText = [@"<" stringByAppendingString:tagText];
		
		// -- PRZETWARZANIE ZNACZNIKÓW -- 
		
		// Znaczniki nagłówków.
		if (STRMATCH(tagText, @"</h")) // Zakończenie każdego nagłówka.
		{
			hlevel = 0;
			[stringHelper appendFormat:@"\n"];
			fontSize = BASE_TEXT_SIZE;
		}
		else if (STRMATCH(tagText, @"<h1>")) hlevel = 1;
		else if (STRMATCH(tagText, @"<h2>")) hlevel = 2;
		else if (STRMATCH(tagText, @"<h3>")) hlevel = 3;
		else hlevel = 0;
		if (hlevel)
			fontSize = BASE_TEXT_SIZE + (8.0f - hlevel) * 2.0f;
		
		// Znaczniki pogrubienia i pochylenia.
		if (STRMATCH(tagText, @"</i>"))			emph = NO;
		else if (STRMATCH(tagText, @"<i>"))		emph = YES;
		else if (STRMATCH(tagText, @"</b>"))	bold = NO;
		else if (STRMATCH(tagText, @"<b>"))		bold = YES;
		
		// Znaczniki pogrubienia i pochylenia.
		if (STRMATCH(tagText, @"</center>"))
			stringHelper.alignment = @"natural";
		else if (STRMATCH(tagText, @"<center>"))
			stringHelper.alignment = @"center";
		
		// Znaczniki pogrubienia i pochylenia.
		
		if (STRMATCH(tagText, @"<color red>"))
			stringHelper.foregroundColor = [UIColor redColor];
		if (STRMATCH(tagText, @"<color green>"))
			stringHelper.foregroundColor = [UIColor greenColor];
		if (STRMATCH(tagText, @"<color blue>"))
			stringHelper.foregroundColor = [UIColor blueColor];
		else if (STRMATCH(tagText, @"</color")) // Częściowe dopasowanie.
			stringHelper.foregroundColor = [UIColor blackColor];
		
		if (STRMATCH(tagText, @"<size")) // Częściowe dopasowanie.
		{
			// Skanowanie w poszukiwaniu wartości dla nowej wielkości czcionki.
			NSScanner *newScanner = [NSScanner scannerWithString:tagText];
			NSCharacterSet *cs = [[NSCharacterSet decimalDigitCharacterSet] invertedSet];
			[newScanner setCharactersToBeSkipped:cs];
			[newScanner scanFloat:&fontSize];
		}
		else if (STRMATCH(tagText, @"</size>"))
			fontSize = BASE_TEXT_SIZE;
		
        
		// Znaczniki ograniczające akapit oraz znak nowego wiersza.
		if (STRMATCH(tagText, @"<br")) // Dopasowanie wszystkich wariantów.
			[stringHelper appendFormat:@"\n"];
		else if (STRMATCH(tagText, @"</p>"))
			[stringHelper appendFormat:@"\n\n"];
		else if (STRMATCH(tagText, @"<p>")) // Wyrównanie domyślne.
			stringHelper.alignment = @"natural";
	}
    
    return stringHelper.string;
}

@end
